# 画面設計書 4-Runtime Error

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のRuntime Error画面（Page ID: 3）の設計書である。Runtime Error画面は、テスト実行中に発生したランタイムエラーの詳細を表示するモーダルダイアログ画面である。

### 本画面の処理概要

Runtime Error画面は、ユニットテスト実行中に発生した例外やエラーの詳細情報を表示する。Dashboard画面のTest Executions Reportで、エラー状態（Error）のレコードにランタイムエラーアイコンが表示され、そのアイコンをクリックすることで本画面が開く。

**業務上の目的・背景**：ユニットテスト実行中に発生するランタイムエラー（SQLエラー、PL/SQL例外など）は、テストの品質に大きく影響する。本画面は、エラーのバックトレース情報を含む詳細なエラーメッセージを表示することで、開発者がエラーの原因を特定し、問題を迅速に解決できるようにする。エラー情報には、エラーメッセージ（SQLERRM）とフォーマットされたエラーバックトレース（DBMS_UTILITY.format_error_backtrace）が含まれる。

**画面へのアクセス方法**：Dashboard画面のTest Executions Reportから、ランタイムエラーアイコン（fa-exclamation-triangle）をクリックしてモーダルダイアログとして開く。P3_QATR_ID（テスト結果ID）がURLパラメータとして渡される。

**主要な操作・処理内容**：
1. P3_QATR_IDに基づいてQA_TEST_RUNSテーブルからランタイムエラー情報を取得
2. エラー内容をテキストエリアとして表示（読み取り専用）
3. Closeボタンでダイアログを閉じて親画面に戻る

**画面遷移**：
- 遷移元：Dashboard画面（Test Executions Reportのランタイムエラーアイコン）
- 遷移先：なし（モーダルダイアログのためCloseで親画面に戻る）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | テスト実行履歴格納 | 主機能 | QA_TEST_RUNSテーブルからランタイムエラー情報を表示 |

## 画面種別

モーダルダイアログ（詳細表示系・読み取り専用）

## URL/ルーティング

- Page ID: 3
- エイリアス: RUNTIME-ERROR
- URL例: `f?p=141:3:SESSION_ID::NO::P3_QATR_ID:123`

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 項目ID | タイプ | 必須 | 説明 |
|--------|--------|--------|------|------|
| QATR ID | P3_QATR_ID | Hidden | Yes | テスト実行結果のプライマリキー |

### 表示項目（読み取り専用）

| 項目名 | 項目ID | タイプ | データソース | 説明 |
|--------|--------|--------|-------------|------|
| Runtime Error | P3_RUNTIME_ERROR | テキストエリア（読み取り専用） | QA_TEST_RUNS.QATR_RUNTIME_ERROR | エラーメッセージとバックトレース |

### ボタン

| ボタン名 | 項目ID | 配置位置 | アクション |
|---------|--------|----------|----------|
| Close | CLOSE | CLOSE | ダイアログを閉じる |

## イベント仕様

### 1-Close Dialog

**トリガー**: CLOSEボタンクリック

**処理フロー**:
1. ダイアログを閉じる（NATIVE_DIALOG_CLOSE）

## データベース更新仕様

### 操作別データベース影響一覧

Runtime Error画面は読み取り専用であり、データベース更新は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページロード | QA_TEST_RUNS | SELECT | P3_QATR_IDに基づいてランタイムエラー情報を取得 |

### プロセス別詳細

#### Initialize form Runtime Error（Before Header）

**実行タイミング**: ページヘッダー生成前

**処理内容**:
- QA_TEST_RUNSテーブルから、P3_QATR_IDに対応するレコードを取得
- QATR_RUNTIME_ERRORカラムの値をP3_RUNTIME_ERRORに設定

**SQLクエリ**:
```sql
SELECT QATR_RUNTIME_ERROR
FROM QA_TEST_RUNS
WHERE QATR_ID = :P3_QATR_ID
```

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | ランタイムエラーがない場合 | （空表示） |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| P3_QATR_IDが無効 | フォーム初期化でエラー、空のダイアログが表示される |
| レコードが見つからない | P3_RUNTIME_ERRORは空で表示 |

## 備考

- 本画面はモーダルダイアログとして表示され、親画面（Dashboard）の上に重ねて表示される
- テキストエリアの高さは15行（cHeight=>15）に設定されており、長いエラーメッセージもスクロールで確認可能
- ランタイムエラーには通常、SQLERRM（エラーメッセージ）とDBMS_UTILITY.format_error_backtrace（エラー発生箇所のスタックトレース）の両方が含まれる
- エラー情報はqa_unit_tests_pkg.p_handle_test_exceptionにより、テスト実行時にQA_TEST_RUNS.QATR_RUNTIME_ERRORに保存される
- AutocompleteはセキュリティのためOFFに設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00003.sql | `src/apex/f141/application/pages/page_00003.sql` | モーダルダイアログの構成とフォーム定義 |

**主要処理フロー**:
1. **行14-24**: `wwv_flow_imp_page.create_page`でモーダルダイアログ設定
2. **行25-46**: Runtime Errorリージョン（NATIVEフォーム）の定義
3. **行47-62**: Buttons Containerリージョンの定義
4. **行63-78**: CLOSEボタンの定義
5. **行79-117**: フォームアイテム定義（P3_QATR_ID、P3_RUNTIME_ERROR）
6. **行118-137**: Dynamic Action（Close Dialog）の定義
7. **行138-147**: フォーム初期化プロセスの定義

#### Step 2: エラー保存ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_exceptionの実装 |

**主要処理フロー**:
- **行1143-1168**: `p_handle_test_exception`でランタイムエラーをQA_TEST_RUNSに保存
- **行1164-1166**: QATR_RUNTIME_ERRORカラムにエラー情報をUPDATE

### プログラム呼び出し階層図

```
Runtime Error Page (Page 3)
    |
    +-- [Page Load - Before Header]
    |       |
    |       +-- Initialize form Runtime Error (NATIVE_FORM_INIT)
    |               |
    |               +-- SELECT FROM QA_TEST_RUNS WHERE QATR_ID = :P3_QATR_ID
    |                       |
    |                       +-- P3_RUNTIME_ERROR <- QATR_RUNTIME_ERROR
    |
    +-- [Button: CLOSE]
            |
            +-- Dynamic Action: Close Dialog
                    |
                    +-- NATIVE_DIALOG_CLOSE
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Dashboard画面               Page 3 Load                      Runtime Error
(P3_QATR_ID)        ───>   Initialize form           ───>   表示
    |                            |                          (P3_RUNTIME_ERROR)
    v                            v
テスト実行時                QA_TEST_RUNS
    |                       .QATR_RUNTIME_ERROR
    v
qa_unit_tests_pkg
.p_handle_test_exception
    |
    v
UPDATE QA_TEST_RUNS
SET QATR_RUNTIME_ERROR = pi_runtime_error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00003.sql | `src/apex/f141/application/pages/page_00003.sql` | ソース | Runtime Error画面定義 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | エラー保存処理（p_handle_test_exception） |
| page_00001.sql | `src/apex/f141/application/pages/page_00001.sql` | ソース | Dashboard画面（呼び出し元） |
